IF EXISTS(SELECT * 
		FROM SYS.SYSOBJECTS 
		WHERE NAME ='P_ANALISE_VENDA_PRODUTOS_MENSAL_FILIAL_EXEC_ALL' AND TYPE=N'P')
BEGIN
	DROP PROCEDURE P_ANALISE_VENDA_PRODUTOS_MENSAL_FILIAL_EXEC_ALL
END
GO
GO 
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_MENSAL_FILIAL_EXEC_ALL] @CD_EMP INT=1, @ANO INT=NULL, @MES VARCHAR(2)=NULL AS 
	SET NOCOUNT ON
	
	DECLARE @cd_filial INT, @mesFechamento DATETIME
		
	IF @ano IS NULL OR @mes IS NULL
		SELECT @mesFechamento=  GETDATE() , @ano=YEAR(@mesFechamento), @mes=MONTH(@mesFechamento)

	IF  LEN(@MES)=1 
		SET @MES='0' + @MES

	SELECT @mesFechamento = CONVERT(CHAR(4), @ano) + CONVERT(CHAR(2), @mes) + '01'
	PRINT 'Processamento analise mensal para todas as filiais mes base ' + right(convert(char(10),@mesFechamento,103),7)+ ':'
	
	DECLARE filiais CURSOR FAST_FORWARD FOR 
	SELECT CD_FILIAL 
		FROM 
			PRC_FILIAL 
		WHERE
			CD_FILIAL NOT IN (SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO)
			--AND CD_FILIAL > 68
		ORDER BY CD_FILIAL
	
	OPEN filiais
	
	FETCH NEXT FROM filiais INTO @cd_filial
	WHILE @@FETCH_STATUS=0
	  begin
		PRINT	'  Analise mensal filial ' + convert(varchar(5), @cd_filial) + 
				' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
				
		EXECUTE P_ANALISE_VENDA_PRODUTOS_MENSAL_FILIAL  @CD_EMP,@CD_FILIAL, @ANO, @MES;
		 
		FETCH NEXT FROM filiais INTO @cd_filial
	  end
	  
	PRINT 'Conclu?do.'
	CLOSE filiais
	DEALLOCATE filiais
GO
